<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

class Transaction extends AccessTemplate{
	
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('transaction_model', 'transaction');
		$this->load->model('sections_model', 'sections');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('bcode_model', 'bcode');
		$this->load->database('default',true);
	}	
	
	function login(){
	
		//get required parameters
		$username = $this->input->get_post("username");
		$password = $this->input->get_post("password");
		$partyCode = $this->input->get_post("partycode");
		
		if(!$username){
			$this->promptError('ER:01:07');
		}elseif(!$password){
			$this->promptError('ER:01:05');
		}elseif(!$partyCode){
			$this->promptError('ER:01:01');
		
		}else{
		
			//verify credentials and issue accesscode
			$data['result'] = $this->transaction->verify($username, $password, $partyCode);
			
			if($data['result'] == 'Invalid'){
				$this->promptError('ER:02:10');
			}else{
			
				$this->load->view("access_code_xml", $data);
			
			}
			
		}
		
	}
	
	function initialize(){
	
		
		//get required parameters
		$accesscode = $this->input->get_post("accesscode");
		
		if(!$accesscode){
			$this->promptError('ER:01:06');
		}else{
		
			//verify accesscode and generate live token
			$data['result'] = $this->transaction->validateaccesscode($accesscode);
		
			if($data['result'] == 'expired'){
				$this->promptError('ER:03:03');
			}elseif($data['result'] == 'inactive'){
				$this->promptError('ER:02:09');
			}elseif($data['result'] == 'invalid'){
				$this->promptError('ER:02:06');
			}else{
				$this->load->view("initialize_xml", $data);
			}
		}
	}
	
	function renewToken(){
	
		//get required parameters
		$accesscode = $this->input->get_post('accesscode');
		$token = $this->input->get_post('dynatoken');
	
		if(!$accesscode){
			$this->promptError('ER:01:06');
		}elseif(!$token){
			$this->promptError('ER:01:08');
		}else{
	
			$data['result'] = $this->transaction->renewToken($accesscode, $token);
			
			if($data['result'] == 'expired'){
				$this->promptError('ER:03:04');
			}elseif($data['result'] == 'inactive'){
				$this->promptError('ER:02:08');
			}elseif($data['result'] == 'invalid'){
				$this->promptError('ER:02:02');
			}else{
			$this->load->view("initialize_xml", $data);
			}
		
		}
	
	
		
	}

	function purchaseTicket(){

		$ticketDetails = array();
<<<<<<< .mine
		$accesscode = $this->input->get_post('accesscode');
		$token = $this->input->get_post('dynatoken');
		
=======
		$accesscode =  $this->input->get_post("accesscode"); 
		$token =  $this->input->get_post("dynatoken"); 
 		
>>>>>>> .r1928
		// $totalAmount = $_GET['totalAmount'];
		// $payMode = $_GET['payMode'];
<<<<<<< .mine
		 
=======
>>>>>>> .r1928
		
		// $totalAmount = 0;
		// $payMode = 0;
		
		
		if(!$accesscode){
			$this->promptError('ER:01:06');
		}elseif(!$token){
			$this->promptError('ER:01:08');
		}else{
		
			// verify access credentials before processing order request
			$result = $this->transaction->verify_access_token($accesscode, $token);
			
			if($result == 'expired'){ 
				$this->promptError('ER:03:04');
			}elseif($result == 'inactive'){ 
				$this->promptError('ER:02:08');
			}elseif($result == 'invalid'){ 
				$this->promptError('ER:02:02'); 
			}else{
				//if valid
			
				//get ticket parameters
				foreach($_POST['dataMessage'] as $x){
					if(isset($x[0]) && isset($x[1]) && isset($x[2]) && isset($x[3]) && isset($x[4]) && isset($x[5]) && isset($x[6]) && isset($x[7]) && isset($x[8]) && isset($x[9]))
					$ticketDetails[] = explode("|", $x);
				}
				// print_r($ticketDetails);
				
				if(empty($ticketDetails)){
					$this->promptError('ER:06:02'); 
				}else{
				
				
				//CHECK PARAMETErS IS VALID
				
				
				
				
				
				
				 
				
				//buy ticket
				$data['result'] = $this->transaction->buy_ticket($ticketDetails , $accesscode);
				$result = $data['result'];
				$transaction_id = $result[1];
				// $this->post->post2pay($transaction_id, $totalAmount);
				
				$this->load->view("ticket_response_xml", $data);
				}
			}
			
			
			/* accept the following:
					- per ticket info (event id, price id, section id, ticket type, ticket seat, actual charge price, convenience charge) - POST
					- allow multiple tickets
					- for consideration: use message format = EID|PID|SID|TTYPE|SEAT|PRICE|CONVCHARGE
					
					- per buy request(total amount, payment_mode_MIGS) - GET
			*/
			
			// compute for verification of details
			// add to database
		}
	
	}

	function payment_done()
	{
	  
		// $data['TxnResponseCode'] = $_GET['TxnResponseCode'];
		// $data['Message'] = $_GET['Message'];
		// $data['MerchTxnRef'] = $_GET['MerchTxnRef'];
		// $data['OrderInfo'] = $_GET['OrderInfo'];
		// $data['Amount'] = $_GET['Amount'];
		// $data['CardNum'] = $_GET['CardNum'];
		// $data['appCode'] = $_GET['appCode'];
		// $data['liveToken'] = $_GET['liveToken'];
	
		$TxnResponseCode =  $this->input->get_post("TxnResponseCode"); 
		$Message =  $this->input->get_post("Message"); 
		$MerchTxnRef =  $this->input->get_post("MerchTxnRef"); 
		$OrderInfo =  $this->input->get_post("OrderInfo"); 
		$Amount =  $this->input->get_post("Amount"); 
		$AppCode =  $this->input->get_post("appCode"); 
		$liveToken =  $this->input->get_post("liveToken"); 
	
	
		if(!$TxnResponseCode){
			$this->promptError('ER:06:03');
		}elseif(!$Message){
			$this->promptError('ER:06:01');
		}elseif(!$MerchTxnRef){
			$this->promptError('ER:06:04');
		}elseif(!$OrderInfo){
			$this->promptError('ER:06:05');
		}elseif(!$Amount){
			$this->promptError('ER:06:07');
		}elseif(!$AppCode){
			$this->promptError('ER:01:03');
		}elseif(!$LiveToken){
			$this->promptError('ER:01:04');
		}else{
		
		 
	
	
	/* 
		 $paycode = $_GET['paycode'];
		
		$msg = "";
		
	
		// default value
		$pid = 0;
		$eid = 0;
		
		// identify tickets and the price_id/event_id just in case user opened events with new tab
		$selected_tickets = $this->tickets->get_selected_tickets($data['OrderInfo']);
		foreach ($selected_tickets as $ticket) {
			$pid = $ticket->ticket_price_id;
			$eid = $ticket->ticket_event_id;
		}

		// check if valid access
		if (($pid > 0) && ($eid > 0)) { 
			// transaction tickets has valid event_id and price_id info
		} else {
 			//Invalid transaction information.'
			$this->promptError('ER:06:08'); 
		}

		// identify price id from tickets
		$data['price'] =  $this->prices->get($pid);
		
		// identify event id from tickets
		$data['event'] = $this->events->get($eid);
		
		// get total amount
		$ticket_count = count($selected_tickets);
		$total_amount = $ticket_count * $data['price']->price_price;
		
		$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
		$orig_amount = number_format($orig_amount_raw, 2, '', '');
		$bdo_prefix = $this->config->item('bdo_prefix');
		if ($orig_amount != $_GET['Amount'])
		{
			//error message
			//Amount paid did not match the transaction amount
		}
		else if ("$bdo_prefix$transaction_id" != $_GET['MerchTxnRef'])
		{
			//error message
			//Invalid transaction reference.
		}
		else
		{
			$payment_type = $this->payment_types->get_by_code($paycode);
			$this->transactions->paid_online($transaction_id); // mark the transaction as paid_online
			$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
			// $card_num = $this->input->get("CardNum");
			// $this->payments->add_cardnum($transaction_id,$card_num);
			
			$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
			if ($charge_amount > 0) {
				$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
			}
			$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
			$data['payment_type'] = $payment_type->payment_type_name; // payment type
			
			// add receipt numbers
			$transaction = $this->transactions->get($transaction_id);
			
			// OR number
			$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
			if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
			{
				$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
				$this->transactions->update_receipt_number($transaction_id, $or_number);
			}
			else 
			{
				$or_number = 0;
			}
							
			foreach ($selected_tickets as $ticket)
			{
				// AR number
				$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
				$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
				
				
			}

			// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
			// $postrequest = @$this->extension->post2mci($transaction_id);
			// $this->session->unset_userdata('sendSMS');
			// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
		}

  
		 */
		 
		$this->load->view("result_xml");
		}
	}
}
